﻿using UnityEngine;
using System.Collections;

public class CameraScript : MonoBehaviour
{

    private Vector3 oldPosition;
    public float deltaScrollFactor;
    public float maxZoom;
    public float minZoom;
    public float minX;
    public float maxX;
    public float minY;
    public float maxY;
    private float currentZoom;
    public float deltaZoom;
	// Use this for initialization
	void Start ()
	{
	    currentZoom = GetComponent<Camera>().orthographicSize;
	}
	
	// Update is called once per frame
	void FixedUpdate () {

	    if (Application.platform == RuntimePlatform.Android)
	    {
	        if (Input.touchCount >= 2 && Input.touches[0].phase == TouchPhase.Began)
	        {
                oldPosition = Input.touches[0].position;
	        }
            if (Input.touchCount >= 2 && Input.touches[0].phase == TouchPhase.Moved)
            {
                var deltaPos = new Vector3(Input.touches[0].position.x, Input.touches[0].position.y) - oldPosition;
                deltaPos = deltaPos / deltaScrollFactor;
                oldPosition = Input.touches[0].position;
                var newX = transform.position.x - deltaPos.x;
                newX = Mathf.Clamp(newX, minX, maxX);
                var newY = transform.position.y - deltaPos.y;
                newY = Mathf.Clamp(newY, minY, maxY);
                transform.position = new Vector3(newX, newY, transform.position.z);
             }
	    }
	    else
	    {
            if (Input.GetMouseButtonDown(1))
            {
                oldPosition = Input.mousePosition;
            }
            if (Input.GetMouseButton(1))
            {

                var deltaPos = Input.mousePosition - oldPosition;
                deltaPos = deltaPos / deltaScrollFactor;
                oldPosition = Input.mousePosition;
                var newX = transform.position.x - deltaPos.x;
                newX = Mathf.Clamp(newX, minX, maxX);
                var newY = transform.position.y - deltaPos.y;
                newY = Mathf.Clamp(newY, minY, maxY);
                transform.position = new Vector3(newX, newY, transform.position.z);
            }
            if (Input.GetAxis("Mouse ScrollWheel") != 0)
            {
                currentZoom += Input.GetAxis("Mouse ScrollWheel") * deltaZoom;
                currentZoom = Mathf.Clamp(currentZoom, minZoom, maxZoom);
                GetComponent<Camera>().orthographicSize = currentZoom;
            }
	    }
	   
	}

}
